/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import com.metratec.lib.upnp.DeviceDescription;
import com.metratec.lib.upnp.Discovery;
import com.metratec.lib.upnp.UpnpLibrary;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;

public class Device
implements Comparable<Device> {
    private static final String NO_RESPONSE = "The device did not respond to request";
    private InetAddress inetAddress;
    private InetAddress localAddress;
    private String st;
    private String nls;
    private String usn;
    private String location;
    private LoadDeviceDescriptionThread thread = null;
    private DeviceDescription description = null;

    public Device(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void updateDevice() throws Exception {
        String udn = this.getDescription().getUdn();
        Discovery discovery = new Discovery(2000, udn);
        discovery.setIpv6Enabled(this.inetAddress instanceof Inet6Address);
        List<Device> devices = discovery.discover();
        if (0 == devices.size()) {
            UpnpLibrary.getLogger().info(NO_RESPONSE);
            throw new Exception(NO_RESPONSE);
        }
        Device updatedDevice = devices.get(0);
        this.inetAddress = updatedDevice.getInetAddress();
        this.localAddress = updatedDevice.getLocalAddress();
        this.location = updatedDevice.getLocation();
        this.nls = updatedDevice.getNls();
        this.st = updatedDevice.getSt();
        this.usn = updatedDevice.getUsn();
        this.description = updatedDevice.getDescription();
    }

    public DeviceDescription getDescription() {
        return this.getDescription(true);
    }

    public DeviceDescription getDescription(boolean block) {
        if (null != this.description) {
            return this.description;
        }
        if (null == this.thread) {
            this.thread = new LoadDeviceDescriptionThread();
            this.thread.setDaemon(true);
            this.thread.start();
        }
        if (!block) {
            return null;
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.description;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public String getSt() {
        return this.st;
    }

    public void setSt(String st) {
        this.st = st;
    }

    public String getNls() {
        return this.nls;
    }

    public void setNls(String nls) {
        this.nls = nls;
    }

    public String getUsn() {
        return this.usn;
    }

    public void setUsn(String usn) {
        this.usn = usn;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private static int compareBytes(byte[] b1, byte[] b2) {
        int i;
        if (b1.length < b2.length) {
            return -1;
        }
        if (b1.length > b2.length) {
            return 1;
        }
        for (i = 0; i < b1.length && b1[i] == b2[i]; ++i) {
        }
        return i >= b1.length ? 0 : (b1[i] & 0xFF) - (b2[i] & 0xFF);
    }

    @Override
    public int compareTo(Device obj) {
        int cmp = Device.compareBytes(this.inetAddress.getAddress(), obj.getInetAddress().getAddress());
        if (cmp == 0) {
            cmp = this.location.compareTo(obj.getLocation());
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Device)) {
            return false;
        }
        Device device = (Device)obj;
        return this.inetAddress.equals(device.getInetAddress()) && this.location.equals(device.getLocation());
    }

    public int hashCode() {
        return Objects.hash(this.inetAddress, this.location);
    }

    public String toString() {
        return this.inetAddress.getHostAddress() + " (" + this.usn + ")";
    }

    private class LoadDeviceDescriptionThread
    extends Thread {
        private LoadDeviceDescriptionThread() {
        }

        @Override
        public void run() {
            try {
                Device.this.description = new DeviceDescription(Device.this.location);
            }
            catch (Exception ex) {
                UpnpLibrary.getLogger().error("Failed to get device description from: " + Device.this.location, (Throwable)ex);
            }
        }
    }
}

