/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import com.metratec.lib.auth.BasicAuthentication;
import com.metratec.lib.auth.DigestRequest;
import com.metratec.lib.auth.DigestResponse;
import com.metratec.lib.upnp.Action;
import com.metratec.lib.upnp.Argument;
import com.metratec.lib.upnp.Service;
import com.metratec.lib.upnp.UpnpLibrary;
import com.metratec.lib.upnp.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CallAction {
    private String username = "username";
    private String password = "password";
    private String authorization = "";
    private final Service service;
    private final Action action;
    private final URL url;
    private final String method = "POST";
    private final String soapAction;
    private final String uri;
    private final int timeout;
    private byte[] bodyBytes;

    public CallAction(Action action, int timeout) throws MalformedURLException, ParserConfigurationException, UnsupportedEncodingException {
        this.action = action;
        this.timeout = timeout;
        this.service = action.getService();
        this.uri = this.service.getControlURL();
        this.url = new URL(this.service.getBaseURL(), this.service.getControlURL());
        this.soapAction = "\"" + this.service.getServiceType() + "#" + action.getName() + "\"";
    }

    private String getBodyText() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element envelopeElement = doc.createElement("s:Envelope");
        envelopeElement.setAttribute("xmlns:s", "http://schemas.xmlsoap.org/soap/envelope/");
        envelopeElement.setAttribute("s:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
        doc.appendChild(envelopeElement);
        Element bodyElement = doc.createElement("s:Body");
        envelopeElement.appendChild(bodyElement);
        Element actionElement = doc.createElement("u:" + this.action.getName());
        actionElement.setAttribute("xmlns:u", this.service.getServiceType());
        bodyElement.appendChild(actionElement);
        List<Argument> inputArguments = this.action.getInputArguments();
        if (null != inputArguments) {
            for (Argument argument : inputArguments) {
                Element argumentElement = doc.createElement(argument.getName());
                argumentElement.setTextContent(argument.getValue());
                actionElement.appendChild(argumentElement);
            }
        }
        String result = null;
        try {
            result = Utils.toPrettyString(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public List<Argument> execute() throws IOException, ProtocolException, Exception {
        String body = this.getBodyText();
        UpnpLibrary.getLogger().info(body);
        this.bodyBytes = body.getBytes("UTF-8");
        return this.execute(true);
    }

    private List<Argument> execute(boolean repeat) throws IOException, ProtocolException, Exception {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        conn.setConnectTimeout(this.timeout);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.addRequestProperty("Host", this.url.getHost());
        conn.addRequestProperty("Content-Length", Integer.toString(this.bodyBytes.length));
        conn.addRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
        conn.addRequestProperty("Accept", "text/xml;");
        conn.addRequestProperty("Authorization", this.authorization);
        conn.addRequestProperty("SOAPACTION", this.soapAction);
        conn.addRequestProperty("Cache-Control", "no-cache");
        conn.connect();
        OutputStream os = conn.getOutputStream();
        os.write(this.bodyBytes);
        os.flush();
        os.close();
        Document doc = null;
        switch (conn.getResponseCode()) {
            case 401: {
                Map<String, List<String>> headers = conn.getHeaderFields();
                String authHeader = headers.get("WWW-Authenticate").get(0);
                if (authHeader.startsWith("Basic ")) {
                    this.authorization = BasicAuthentication.getAuthorizationHeader(this.username, this.password);
                } else if (authHeader.startsWith("Digest ")) {
                    DigestRequest digestRequest = new DigestRequest(authHeader);
                    DigestResponse digestResponse = new DigestResponse(digestRequest);
                    digestResponse.setUsername(this.username);
                    digestResponse.setPassword(this.password);
                    digestResponse.setMethod("POST");
                    digestResponse.setUri(this.uri);
                    digestResponse.generateResponse();
                    this.authorization = digestResponse.toString();
                }
                if (repeat) {
                    return this.execute(false);
                }
                throw new Exception("Authentication failed!");
            }
            case 500: {
                doc = Utils.parseXML(conn.getErrorStream());
                break;
            }
            case 200: {
                doc = Utils.parseXML(conn.getInputStream());
                break;
            }
        }
        if (doc == null) {
            throw new Exception("Calling action failed with code - " + conn.getResponseCode());
        }
        return this.parseActionResponse(doc);
    }

    private List<Argument> parseActionResponse(Document doc) throws Exception {
        List<Object> arguments = new ArrayList();
        NodeList response = doc.getElementsByTagName("u:" + this.action.getName() + "Response");
        if (response.getLength() != 0) {
            Element responseEl = (Element)response.item(0);
            arguments = this.action.getOutputArguments();
            for (Argument argument : arguments) {
                argument.setValue(Utils.getElementsText(responseEl, argument.getName()));
            }
        } else {
            String errorCode = Utils.getElementsText(doc.getDocumentElement(), "errorCode");
            String errorDescription = Utils.getElementsText(doc.getDocumentElement(), "errorDescription");
            UpnpLibrary.getLogger().warn("Invoking action failed - ", (Object)Utils.toPrettyString(doc));
            throw new Exception("Invoking action failed - " + errorDescription + " (Code: " + errorCode + ")");
        }
        return arguments;
    }
}

