/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import com.metratec.lib.upnp.Argument;
import com.metratec.lib.upnp.Service;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Action {
    private final String name;
    private final Service service;
    private List<Argument> inputArguments = null;
    private List<Argument> outputArguments = null;

    public Action(String name, Service service) {
        this.name = name;
        this.service = service;
    }

    public String getName() {
        return this.name;
    }

    public Service getService() {
        return this.service;
    }

    public List<Argument> getInputArguments() {
        return this.inputArguments;
    }

    public List<Argument> getOutputArguments() {
        return this.outputArguments;
    }

    protected void setInputArguments(List<Argument> inputArguments) {
        if (null == this.inputArguments) {
            this.inputArguments = Collections.unmodifiableList(inputArguments);
        }
    }

    protected void setOutputArguments(List<Argument> outputArguments) {
        if (null == this.outputArguments) {
            this.outputArguments = Collections.unmodifiableList(outputArguments);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.service.getServiceType());
        sb.append("#");
        sb.append(this.name);
        sb.append(", input: [");
        sb.append(this.inputArguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
        sb.append("], output: [");
        sb.append(this.outputArguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
        sb.append("]");
        return sb.toString();
    }
}

