/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.auth;

import com.metratec.lib.auth.DigestRequest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class DigestResponse {
    private static final int NONCE_LENGTH = 16;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private String method = "GET";
    private String username = "";
    private String password = "";
    private String realm = "";
    private String nonce = "";
    private String uri = "";
    private String response = "";
    private String opaque = "";
    private String qop = "";
    private String nc = "";
    private String cnonce = "";
    private String algorithm = "MD5";
    private MessageDigest messageDigest = null;

    public DigestResponse(DigestRequest digestRequest) {
        this.realm = digestRequest.getRealm();
        this.nonce = digestRequest.getNonce();
        this.qop = digestRequest.getQop().split(",")[0];
        this.opaque = digestRequest.getOpaque();
        this.algorithm = digestRequest.getAlgorithm();
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("Invalid algorithm specified - " + this.algorithm);
            System.err.println("Using MD5!");
            try {
                this.messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setQop(String qop) {
        this.qop = qop;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        this.messageDigest = MessageDigest.getInstance(algorithm);
        this.algorithm = algorithm;
    }

    private static String createRandomHexString(int length) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Integer.toHexString(SECURE_RANDOM.nextInt(16)));
        }
        return sb.toString();
    }

    public String generateResponse() {
        return this.generateResponse(DigestResponse.createRandomHexString(16), 1);
    }

    public String generateResponse(String cnonce) {
        return this.generateResponse(cnonce, 1);
    }

    public String generateResponse(String cnonce, int ncount) {
        this.cnonce = cnonce;
        this.nc = String.format("%08x", ncount);
        String ha1 = this.getHash(this.username + ":" + this.realm + ":" + this.password);
        String ha2 = this.getHash(this.method + ":" + this.uri);
        this.response = this.qop.equals("auth") ? this.getHash(ha1 + ":" + this.nonce + ":" + this.nc + ":" + cnonce + ":" + this.qop + ":" + ha2) : this.getHash(ha1 + ":" + this.nonce + ":" + ha2);
        return this.response;
    }

    public String toString() {
        if (this.qop.equals("auth")) {
            return String.format("Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", qop=%s, nc=%s, cnonce=\"%s\", response=\"%s\", opaque=\"%s\", algorithm=%s", this.username, this.realm, this.nonce, this.uri, this.qop, this.nc, this.cnonce, this.response, this.opaque, this.algorithm);
        }
        return String.format("Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\", opaque=\"%s\", algorithm=%s", this.username, this.realm, this.nonce, this.uri, this.response, this.opaque, this.algorithm);
    }

    private String getHash(String text) {
        this.messageDigest.reset();
        this.messageDigest.update(text.getBytes());
        byte[] byteData = this.messageDigest.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            String hex = Integer.toHexString(0xFF & byteData[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

