/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.auth;

public class DigestRequest {
    private String realm = "";
    private String qop = "";
    private String nonce = "";
    private String opaque = "";
    private String algorithm = "MD5";

    public DigestRequest(String authHeader) {
        String[] tokens = authHeader.split(", ");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.contains("realm=")) {
                this.realm = token.split("\"")[1];
                continue;
            }
            if (token.contains("qop=")) {
                this.qop = token.split("\"")[1];
                continue;
            }
            if (token.contains("nonce=")) {
                this.nonce = token.split("\"")[1];
                continue;
            }
            if (token.contains("opaque=")) {
                this.opaque = token.split("\"")[1];
                continue;
            }
            if (!token.contains("algorithm=")) continue;
            this.algorithm = token.split("=")[1];
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return String.format("Digest realm=\"%s\", qop=\"%s\", nonce=\"%s\", opaque=\"%s\", algorithm=%s", this.realm, this.qop, this.nonce, this.opaque, this.algorithm);
    }
}

